<?php $__env->startSection('title','Plans'); ?>

<?php $__env->startSection('head'); ?>
    <?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Plans','button_name'=>'Add
    Plan','button_link'=>route('admin.plan.create')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><?php echo e(__('All Plans')); ?></h4>
            </div>
            <div class="card-body">
                <?php if(Session::has('message')): ?>
                    <div class="alert alert-warning"><?php echo e(Session::get('message')); ?></div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-striped" id="table-2">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Title')); ?></th>
                                <th><?php echo e(__('Price')); ?></th>
                                <th><?php echo e(__('Total Orders')); ?></th>
                                <th><?php echo e(__('Total Sales Of Amount')); ?></th>
                                <th><?php echo e(__('Featured')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Last Update')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($plan->name); ?></td>
                                    <td><?php echo e($plan->price); ?></td>
                                    <td><?php echo e($plan->orders_count); ?></td>
                                    <td><?php echo e($plan->orders_sum_amount ?? 0.00); ?></td>
                                    <?php if($plan->is_featured == 1): ?>
                                        <td><span class="badge badge-success"><?php echo e(__('Yes')); ?></span></td>
                                    <?php endif; ?>
                                    <?php if($plan->is_featured == 0): ?>
                                        <td><span class="badge badge-danger"><?php echo e(__('No')); ?></span></td>
                                    <?php endif; ?>

                                    <td><span
                                            class="badge badge-<?php echo e($plan->status ? 'success' : 'danger'); ?>"><?php echo e($plan->status ? 'Active' : 'Inactive'); ?></span>
                                    </td>
                                    <td><?php echo e(date('d-m-Y', strtotime($plan->created_at))); ?></td>
                                    <td>
                                        <div class="dropdown d-inline">
                                            <button class="btn btn-primary dropdown-toggle" type="button"
                                                id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                Action
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item has-icon"
                                                    href="<?php echo e(route('admin.plan.edit', $plan->id)); ?>"><i
                                                        class="fa fa-edit"></i><?php echo e(__('edit')); ?></a>
                                                <a class="dropdown-item has-icon delete-confirm"
                                                    href="javascript:void(0)" data-id=<?php echo e($plan->id); ?>><i
                                                        class="fa fa-trash"></i><?php echo e(__('Delete')); ?></a>
                                                <!-- Delete Form -->
                                                <form class="d-none" id="delete_form_<?php echo e($plan->id); ?>"
                                                    action="<?php echo e(route('admin.plan.destroy', $plan->id)); ?>"
                                                    method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo e($plans->links('vendor.pagination.bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>