<?php $__env->startSection('title','Projects'); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Project'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <div class="row">
        <div class="col-lg-12 mb-4">
          <?php if(Session::has('success')): ?>
              <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
          <?php endif; ?>
          <div class="row">
            <div class="col-md-4">
              <div class="form">
                <form action="<?php echo e(route('user.project.search')); ?>" method="get">
                  <div class="input-group mb-2">
                    <input type="text" name="q" id="src" class="form-control" placeholder="Search..." required="" autocomplete="off" value="">
                    <select class="form-control" name="type" id="type">
                        <option value="name"><?php echo e(__('Search By Name')); ?></option>
                    </select>
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                    </div>
                  </div>
                </form>
              </div>
            </div>
            <div class="col-md-8 text-right">
              <a class="btn btn-primary pull-right" href="#" data-toggle="modal" data-target="#create_project"><?php echo e(__('Create New Project')); ?></a>
            </div>
          </div> 
        </div>
        <div class="col-lg-12">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col"><?php echo e(__('Sl.')); ?></th>
                <th scope="col"><?php echo e(__('Name')); ?></th>
                <th scope="col"><?php echo e(__('Progress')); ?></th>
                <th scope="col"><?php echo e(__('Description')); ?></th>
                <th scope="col"><?php echo e(__('Details')); ?></th>
                <th scope="col"><?php echo e(__('Status')); ?></th>
                <th scope="col"><?php echo e(__('Members')); ?></th>
                <th scope="col"><?php echo e(__('Action')); ?></th>
              </tr>
            </thead>
              <tbody>
              <?php $__currentLoopData = $projects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <th scope="row"><?php echo e($key+1); ?></th>
                <td><a href="<?php echo e(route('user.project.show', $project->id)); ?>"><?php echo e($project->name); ?></a></td>
                <td class="align-middle">
                  <?php $percentage = 0; ?>
                  <?php if($project->column_count > 0): ?>
                    <?php $percentage = round((($project->completed_column_count / $project->column_count) * 100), 2) ?> 
                  <?php endif; ?>
                  <div class="progress custom-progress" data-height="6" data-toggle="tooltip" title="" data-original-title="<?php echo e($percentage); ?>%">
                    <div class="progress-bar bg-success" id="progress_bar_<?php echo e($project->id); ?>" data-width="<?php echo e($percentage); ?>"></div>
                  </div>
                </td>
                <td><?php echo e(Str::limit($project->description, 10, ' ...')); ?></td>
                <td>
                  <?php $total = 0 ?>
                  <?php $__currentLoopData = $project->column; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php $total += $column->pending_task_count ?>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                  <i class="fas fa-check-circle"></i> <?php echo e($total); ?> <?php echo e(__('Tasks Left')); ?>

                  </div>
                    <div>
                      <i class="fas fa-calendar-alt"></i> <?php echo e(Carbon\Carbon::now() <= $project->ending_date ? Carbon\Carbon::parse($project->ending_date)->diffForHumans() :  'Expired'); ?>

                    </div>
                  </td>
                <td>
                  <div>
                      <?php
                      $status = [
                        0 => [ 'color' => 'badge-danger', 'text' =>  'Inactive' ] ,
                        1 => [ 'color' => 'badge-success', 'text' =>  'Finished' ] ,
                        2 => [ 'color' => 'badge-primary', 'text' =>  'Pending' ] 
                      ][$project->status];
                      ?>
                      <div class="badge <?php echo e($status['color']); ?>"><?php echo e($status['text']); ?></div>
                  </div>
                </td>
                <td>
                  <?php $__currentLoopData = $project->projectuser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <img data-toggle="tooltip" data-original-title="<?php echo e($member->user->name); ?>" alt="image" src="<?php echo e($member->user->avatar != null ? asset($member->user->avatar) : 'https://ui-avatars.com/api/?background=random&name='.$member->user->name); ?>" class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="">
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                  <div class="dropdown d-inline">
                    <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      <?php echo e(__('Action')); ?>

                    </button>
                    <div class="dropdown-menu">
                      <a class="dropdown-item has-icon" href="<?php echo e(route('user.project.show', $project->id)); ?>"><i class="fa fa-eye"></i><?php echo e(__('View')); ?></a>
                      <?php if($project->user_id == Auth::id()): ?>
                      <a class="dropdown-item has-icon" href="<?php echo e(route('user.project.edit', $project->id)); ?>"><i class="fa fa-edit"></i><?php echo e(__('edit')); ?></a>
                     
                      <?php endif; ?>
                    </div>
                  </div>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
             </tbody>
            </table>
            <?php echo e($projects->links('vendor.pagination.bootstrap-4')); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!--modal start here.....................-->
<!-- Modal -->
<div class="modal fade" id="create_project" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">  
    <?php if($total_project <= $project_limit): ?>
    <form method="post"  action="<?php echo e(route('user.project.store')); ?>" class="basicform_with_reload">
      <?php echo csrf_field(); ?>
      <?php endif; ?>  
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Create New Project')); ?></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="card-body">
              <ul class="nav nav-pills" id="myTab3" role="tablist">
                <li class="nav-item">
                  <a class="nav-link active" id="home-tab3" data-toggle="tab" href="#home3" role="tab" aria-controls="home" aria-selected="true"><?php echo e(__('Project Info')); ?></a>
                </li>
                <li class="nav-item">
                  <a class="nav-link team disable_cursor" id="profile-tab3" data-toggle="tab" href="#profile3" role="tab" aria-controls="profile" aria-selected="false"><?php echo e(__('Team Members')); ?></a>
                </li>
                <li class="nav-item">
                  <a  class="nav-link group disable_cursor" id="contact-tab3" data-toggle="tab" href="#contact3" role="tab" aria-controls="contact" aria-selected="false"><?php echo e(__('Group')); ?></a>
                </li>
              </ul>
              <div class="tab-content" id="myTabContent2">
                <div class="tab-pane fade show active" id="home3" role="tabpanel" aria-labelledby="home-tab3">
                  <div class="form-group">
                    <label for="name"><?php echo e(__('Enter Project Name')); ?></label>
                    <input type="text" class="form-control" required name="project_name" placeholder="<?php echo e(__('Enter Project Name')); ?>">
                  </div>
                  <div class="form-group">
                    <label for="name"><?php echo e(__('Project Description')); ?></label>
                    <input type="text" class="form-control" required name="project_description" placeholder="<?php echo e(__('Project Description')); ?>">
                  </div>
                  <div class="form-group">
                    <label for="name"><?php echo e(__('Timeline')); ?></label>
                    <input type="text" class="form-control daterange-cus-left" required name="project_time">
                  </div>
                  <div class="section-title"><b><?php echo e(__('Project Type')); ?></b></div>
                  <div class="form-group">
                    <div class="custom-control custom-radio">
                      <input type="radio" checked id="me" value="0" name="project_type" class="custom-control-input project_type">
                      <label class="custom-control-label" for="me"><b><?php echo e(__('Only me')); ?></b></label>
                  </div>
                    <p class="ml-4"><?php echo e(__('Only you can see this project')); ?></p>
                  </div>
                  <div class="form-group">
                    <div class="custom-control custom-radio">
                      <input type="radio" id="team" value="2" name="project_type" class="custom-control-input project_type">
                      <label class="custom-control-label" for="team"><b><?php echo e(__('Team Members')); ?></b></label>
                  </div>
                    <p class="ml-4"><?php echo e(__('Only assigned team members can see this project')); ?></p>
                  </div>
                  <div class="form-group">
                    <div class="custom-control custom-radio">
                      <input type="radio" id="group" value="3" name="project_type" class="custom-control-input project_type">
                      <label class="custom-control-label" for="group"><b><?php echo e(__('Group')); ?></b></label>
                  </div>
                    <p class="ml-4"><?php echo e(__('Only assigned group members can see this project')); ?></p>
                  </div>
                  <div class="section-title"><b><?php echo e(__('Users Track')); ?></b></div>
                  <div class="form-group">
                    <label>
                      <input type="checkbox" name="screenshot" name="custom-switch-checkbox" class="custom-switch-input" <?php echo e(($percent > 95 || (!empty($plan->screenshot) && $plan->screenshot) == 0 ) ? 'disabled' : ''); ?>>
                      <span class="custom-switch-indicator"></span>
                      <span class="custom-switch-description mt-2"><?php echo e(__('Capture Screenshot')); ?></span>
                    </label>
                  </div>
                  <div class="form-group">
                    <label>
                      <input type="checkbox" name="gps" name="custom-switch-checkbox" class="custom-switch-input" <?php echo e((!empty($plan->gps) && $plan->gps) == 0 ? 'disabled' : ''); ?>>
                      <span class="custom-switch-indicator"></span>
                      <span class="custom-switch-description mt-2"><?php echo e(__('User Location (GPS)')); ?></span>
                    </label>
                  </div>
                  <div class="form-group">
                    <label>
                      <input type="checkbox" name="mail_activity" name="custom-switch-checkbox" class="custom-switch-input">
                      <span class="custom-switch-indicator"></span>
                      <span class="custom-switch-description mt-2"><?php echo e(__('Mail activity')); ?></span>
                    </label>
                  </div>
                </div>
                <div class="tab-pane fade" id="profile3" role="tabpanel" aria-labelledby="profile-tab3">
                  <div class="form-group">
                    <input type="text" class="form-control" placeholder="Filter" id="filter">
                  </div> 
                  <div class="user_info">
                  <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="form-group" data-name="<?php echo e($user->user->name); ?>">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" id="a<?php echo e($key); ?>" value="<?php echo e($user->user->id); ?>" name="user[]" class="custom-control-input">
                      <label class="custom-control-label" for="a<?php echo e($key); ?>"><figure class="avatar mr-2 avatar-sm">
                        <img src="<?php echo e(asset($user->user->avatar ? null : 'uploads/avatar.png')); ?>" alt="...">
                      </figure><b><?php echo e($user->user->name); ?></b></label>
                  </div>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
                <div class="tab-pane fade" id="contact3" role="tabpanel" aria-labelledby="contact-tab3">
                  <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" id="g<?php echo e($key); ?>" value="<?php echo e($group->id); ?>" name="group[]" class="custom-control-input">
                      <label class="custom-control-label" for="g<?php echo e($key); ?>"><b><?php echo e($group->name); ?></b></label>
                  </div>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <?php if($total_project >= $project_limit): ?> 
            <small class="text-danger text-left float-left"><?php echo e(__('Maximum Project Limit Exceeded')); ?></small>
            <?php endif; ?>
            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
            <button type="submit" class="btn btn-primary basicbtn"  <?php if($total_project >= $project_limit): ?> disabled  <?php endif; ?>><?php echo e(__('Create Now')); ?></button>
          </div>
           <?php if($total_project <= $project_limit): ?>
        </form>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('backend/admin/assets/js/project-edit.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/user/project/index.blade.php ENDPATH**/ ?>