<?php $__env->startSection('title','All Orders'); ?>

<?php $__env->startSection('head'); ?>
    <?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Orders List','button_name'=>'Create
    Order','button_link'=>route('admin.order.create')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card mb-0">
                <div class="card-body">
                    <ul class="nav nav-pills">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'all' || $string == '' ? 'active' : ''); ?>" href="<?php echo e(route('admin.order.filter', 'all')); ?>"><?php echo e(__('All')); ?> <span class="badge 
                              <?php echo e($string == 'all' || $string == '' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($allorders); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'approved' ? 'active' : ''); ?>" href="<?php echo e(route('admin.order.filter', 'approved')); ?>"><?php echo e(__('Approved')); ?> <span class="badge <?php echo e($string == 'approved' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($approved); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'pending' ? 'active' : ''); ?>" href="<?php echo e(route('admin.order.filter', 'pending')); ?>"><?php echo e(__('Pending')); ?> <span class="badge <?php echo e($string == 'pending' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($pending); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'cancel' ? 'active' : ''); ?>" href="<?php echo e(route('admin.order.filter', 'cancel')); ?>"><?php echo e(__('Cancel')); ?> <span class="badge <?php echo e($string == 'cancel' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($cancelled); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'trash' ? 'active' : ''); ?>" href="<?php echo e(route('admin.order.filter', 'trash')); ?>"><?php echo e(__('Trash')); ?> <span class="badge <?php echo e($string == 'trash' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($trash); ?></span></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="float-right">
                        <form action="<?php echo e(route('admin.order.search')); ?>">
                            <div class="input-group">
                                <input type="text" value="<?php echo e($request->q ?? ''); ?>" class="form-control" placeholder="Search" name="q">
                                <select name="filter" id="filter" class="form-control selectric">
                                    <option value="invoice"><?php echo e(__('Invoice No')); ?></option>
                                    <option value="email"><?php echo e(__('User email')); ?></option>
                                    <option value="payment_id"><?php echo e(__('Payment Id')); ?></option>
                                </select>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <form id="status_form" action="<?php echo e(route('admin.order.status')); ?>" method="post">
                      <?php echo csrf_field(); ?>
                    <div class="float-left">
                        <select id="status" name="status" class="form-control selectric">
                            <option value=""><?php echo e(__('Action For Selected')); ?></option>
                            <option value="3"><?php echo e(__('Move to Pending')); ?></option>
                            <option value="0"><?php echo e(__('Move to cancel')); ?></option>
                            <?php if($string != 'trash'): ?>
                            <option value="4"><?php echo e(__('Move to trash')); ?></option>
                            <?php endif; ?>
                            <?php if($string == 'trash'): ?>
                            <option value="5"><?php echo e(__('Delete Pemanently')); ?></option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="clearfix mb-3"></div>
                    <div class="row">
                       <div class="col-md-12">
                        <?php if(Session::has('alert')): ?>
                        <div class="alert alert-danger">
                            <?php echo e(Session::get('alert')); ?>

                        </div>
                        <?php endif; ?>
                       </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="custom-checkbox custom-control">
                                            <input type="checkbox" 
                                                class="custom-control-input checkAll" id="checkbox-all">
                                            <label for="checkbox-all" class="custom-control-label">&nbsp;</label>
                                        </div>
                                    </th>
                                    <th><?php echo e(__('Id')); ?></th>
                                    <th><?php echo e(__('Payment Id')); ?></th>
                                    <th><?php echo e(__('Plan Name')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('User')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Order At')); ?></th>
                                    <th><?php echo e(__('Will Expire')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="custom-checkbox custom-control">
                                                <input name="ids[]" value="<?php echo e($order->id); ?>" type="checkbox" data-checkboxes="mygroup"
                                                    class="custom-control-input" id="checkbox-<?php echo e($order->id); ?>">
                                                <label for="checkbox-<?php echo e($order->id); ?>" class="custom-control-label">&nbsp;</label>
                                            </div>
                                        </td>
                                        <td><a href="<?php echo e(route('admin.user.invoice', $order->id)); ?>"><?php echo e($order->invoice_id); ?></a>
                                        </td>
                                        <td><?php echo e($order->payment_id); ?></td>
                                        <td><?php echo e($order->plan->name); ?></td>
                                        <td><?php echo e($order->amount); ?></td>
                                        <td><a href="<?php echo e(route('admin.user.show', $order->user->id)); ?>"><?php echo e($order->user->name); ?></a>
                                        </td>
                                        <?php
                                            $status = [
                                                0 => ['class' => 'badge-danger', 'text' => 'Rejected'],
                                                1 => ['class' => 'badge-primary', 'text' => 'Accepted'],
                                                2 => ['class' => 'badge-danger', 'text' => 'Expired'],
                                                3 => ['class' => 'badge-warning', 'text' => 'Pending'],
                                                4 => ['class' => 'badge-danger', 'text' => 'Trash'],
                                            ][$order->status];
                                        ?>
                                        <td>
                                            <span class="badge <?php echo e($status['class']); ?>"><?php echo e($status['text']); ?></span>
                                        </td>
                                        <td><?php echo e(date('Y-m-d', strtotime($order->created_at))); ?></td>
                                        <td><?php echo e($order->will_expire); ?></td>
                                        <td>
                                            <div class="dropdown d-inline">
                                                <button class="btn btn-primary dropdown-toggle" type="button"
                                                    id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Action
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.order.show', $order->id)); ?>"><i
                                                            class="fa fa-eye"></i><?php echo e(__('View')); ?></a>
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.order.edit', $order->id)); ?>"><i
                                                            class="fa fa-edit"></i><?php echo e(__('Edit')); ?></a>
                                                   
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.order.deactive', $order->id)); ?>"><i
                                                            class="fa fa-times"></i><?php echo e(__('Deactive')); ?></a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($orders->appends($request->all())->links('vendor.pagination.bootstrap-4')); ?>

                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<input type="hidden" id="type" value="<?php echo e($request->filter ?? ''); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    "use strict";
    
    var type=$('#type').val();
    if(type != ''){
        $('#filter').val(type)
    }
    $('#status').on('change',()=>{
        $('#status_form').submit();  
    })
  </script>
<?php $__env->stopPush(); ?> 


<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/admin/order/index.blade.php ENDPATH**/ ?>