<?php $__env->startSection('title','Time Tracker'); ?>

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Time Tracker'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('beforestyle.css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/selectric.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="">
                            <div class="single-time-card">
                                <div class="row align-items-center">
                                    <div class="col-lg-4">
                                        <div class="select-project">
                                            <div class="form-group">
                                                <label for="filter_status"><?php echo e(__('Select Project')); ?></label>
                                                <select name="project" class="form-control selectric" id="projects">
                                                    <option value=""><?php echo e(__('Select Project')); ?></option>
                                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option data-gps=<?php echo e($project->gps); ?> data-screenshot=<?php echo e($project->screenshot); ?> value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="select-project">
                                            <div class="form-group">
                                                <label for="visibility"><?php echo e(__('Tasks')); ?></label>
                                                <select name="task" class="form-control selectric" id="tasks">
                                                    <option disabled selected value=""><?php echo e(__('Select Task')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="time-count">
                                            <strong id="timer" class="timer px-2">00:00:00</strong>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="start-btn">
                                            <button class="btn btn-primary" type="button" id="startButton" data-task="start">
                                                <span class="spinner-border-sm" role="status" aria-hidden="true"></span>
                                                <span class="text"><?php echo e(__('START')); ?></span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="row d-none" id="share_screen_enable">
                                            <div class="col-lg-4">
                                                <div class="video-show-area">
                                                    <video id="gum-local" autoplay playsinline muted class="video"></video>
                                                </div>
                                            </div>
                                            <div class="col-lg-8">
                                                <div class="row screenshot-img-show-area" id="screenshot_area"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <canvas id="canvas" class="none"></canvas>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="this-week-info">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="week-header">
                                        <h4><?php echo e(__('This Week Reports')); ?></h4>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="project-des showRecentProjects">
                                        <table class="table table-striped">
                                            <thead>
                                              <tr>
                                                <th scope="col"><?php echo e(__('Sl.')); ?></th>
                                                <th scope="col"><?php echo e(__('Project')); ?></th>
                                                <th scope="col"><?php echo e(__('Total Time Track')); ?></th>
                                                <th scope="col"><?php echo e(__('Date')); ?></th>
                                                <th scope="col"><?php echo e(__('Screenshots')); ?></th>
                                                <th scope="col"><?php echo e(__('Analysics')); ?></th>
                                              </tr>
                                            </thead>
                                             <tbody>
                                                 <?php $__currentLoopData = $data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                <th scope="row"><?php echo e($loop->iteration); ?></th>
                                                <td><a href="<?php echo e(route('user.project.show',$item->project_id)); ?>"><?php echo e($item->project->name); ?></a></td>
                                                <td><?php echo e(date("H:i:s", $item->time )); ?></td>
                                                <td>
                                                    <?php echo e(Carbon\Carbon::parse($item->date)->isoFormat('LL')); ?>    
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('user.report.user',
                                                    ['id' => Auth::id(),
                                                    'project_id' => $item->project_id])); ?>" class="btn btn-primary">Manage ScreenShots</a>
                                                </td>
                                                <td>
                                                    
                                                    <?php if(in_array($item->project_id, $project_ids)): ?>
                                                        <?php $is_admin = 1 ?>
                                                    <?php else: ?> 
                                                        <?php $is_admin = 0 ?>
                                                    <?php endif; ?>
                                                    
                                                    <?php if($is_admin == 1): ?>
                                                    <a href="<?php echo e(route('user.report.show',
                                                    ['report' => $item->project_id])); ?>" 
                                                    class="btn btn-danger">Analysics</a>
                                                    <?php endif; ?>
                                                </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="action_url" value="<?php echo e(route('user.time.trackuser')); ?>">
<input type="hidden" id="project_id" value="">
<input type="hidden" id="task_id" value="">
<input type="hidden" id="gps_store" value="<?php echo e(route('user.gps.store')); ?>">
<input type="hidden" id="time_start" value="<?php echo e(route('user.time.start')); ?>">
<input type="hidden" id="time_stop" value="<?php echo e(route('user.time.stop')); ?>">
<input type="hidden" id="screenshot" value="">
<input type="hidden" id="gps" value="">
<input type="hidden" id="getTasksRoute" value="<?php echo e(route('user.get.tasks')); ?>">
<input type="hidden" id="screenshoturl" value="<?php echo e(route('user.upload.screenshot')); ?>">
<input type="hidden" id="alertfile" value="<?php echo e(asset('backend/admin/assets/beep.mp3')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/jquery.selectric.min.js')); ?>"></script>
<script src="https://webrtc.github.io/adapter/adapter-latest.js"></script>
<script src="<?php echo e(asset('backend/admin/assets/js/gps.js')); ?>"></script>
<script src="<?php echo e(asset('backend/admin/assets/js/timetracker.js?v=1.0.0')); ?>"></script>
<?php $__env->stopPush(); ?>








<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/user/timetracker/index.blade.php ENDPATH**/ ?>