<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
     <link rel="apple-touch-icon" href="<?php echo e(asset('pwa/152_152.png')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="white"/>
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="<?php echo e(env('APP_URL')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('pwa/128_128.png')); ?>">
    <meta name="msapplication-TileColor" content="#FFFFFF">
   
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <link rel="icon" href="<?php echo e(asset('uploads/favicon.ico')); ?>">
    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/chocolat.css')); ?>">
    <?php echo $__env->yieldPushContent('beforestyle.css'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/style.css?v=1.1.1')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/components.css')); ?>">
    <?php echo $__env->yieldPushContent('css'); ?>

   
</head>

<body>
  <div id="app">
    <div class="main-wrapper">
      <!--- Header Section ---->
      <?php echo $__env->make('layouts.backend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <!--- Sidebar Section --->
      <?php echo $__env->make('layouts.backend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <!--- Main Content --->
      <div class="main-content  main-wrapper-1">
        <section class="section">
         <?php echo $__env->yieldContent('head'); ?>
        </section>
        <?php echo $__env->yieldContent('content'); ?>
      </div>

     <!--- Footer Section --->
     <?php echo $__env->make('layouts.backend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
  </div>

  <input type="hidden" class="base_url" value="<?php echo e(url('/')); ?>">
  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('frontend/assets/js/jquery-3.6.0.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/popper.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/bootstrap.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/jquery.nicescroll.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/moment.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
  <!-- Template JS File -->
  <script src="<?php echo e(asset('backend/admin/assets/js/chocolat.js')); ?>"></script>
  <!-- Page Specific JS File -->
  <?php echo $__env->yieldPushContent('js'); ?>
  <script src="<?php echo e(asset('backend/admin/assets/js/scripts.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/custom.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/form.js')); ?>"></script>
  <?php if(Auth()->user()->role_id == 2): ?>
  <script src="<?php echo e(asset('backend/admin/assets/js/notification.js')); ?>"></script>
  <?php endif; ?>
  
</body>
</html>
<?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/layouts/backend/app.blade.php ENDPATH**/ ?>