<?php $__env->startSection('title','Users'); ?>

<?php $__env->startSection('head'); ?>
    <?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'All Users','button_name'=>'Add User','button_link'=>route('admin.user.create')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="row">
        <div class="col-12">
            <div class="card mb-0">
                <div class="card-body">
                    <ul class="nav nav-pills">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == 'all' || $string == '' ? 'active' : ''); ?>" href="<?php echo e(route('admin.user.index')); ?>"><?php echo e(__('All')); ?> <span class="badge 
                              <?php echo e($string == 'all' || $string == '' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($all); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == '1' ? 'active' : ''); ?>" href="<?php echo e(route('admin.user.index','status='. 1)); ?>"><?php echo e(__('Active users')); ?> <span class="badge <?php echo e($string == '1' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($active_users); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == '0' ? 'active' : ''); ?>" href="<?php echo e(route('admin.user.index','status='. 0)); ?>"><?php echo e(__('Active users')); ?> <span class="badge <?php echo e($string == '0' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($deactive_users); ?></span></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e($string == '2' ? 'active' : ''); ?>" href="<?php echo e(route('admin.user.index','status='. 2)); ?>"><?php echo e(__('Trash')); ?> <span class="badge <?php echo e($string == '2' ? 'badge-white' : 'badge-primary'); ?>"><?php echo e($trash); ?></span></a>
                        </li>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12">
            <div class="card">
                 <?php if(Session::has('success')): ?>
                 <div class="card-header">                 
                    <div class="alert alert-success">
                        <?php echo e(Session::get('success')); ?>

                    </div>                   
                </div>
                 <?php endif; ?>
                <div class="card-body">
                    <div class="float-right">
                        <form>
                            <div class="input-group">
                                <input type="text" value="<?php echo e($request->q ?? ''); ?>" class="form-control" placeholder="Search" name="q">
                                <select name="filter" id="filter" class="form-control selectric">
                                    <option value="name"><?php echo e(__('User Name')); ?></option>
                                    <option value="email"><?php echo e(__('User Email')); ?></option>
                                    <option value="id"><?php echo e(__('User Id')); ?></option>
                                </select>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <form id="status_form" action="<?php echo e(route('admin.users.status')); ?>" method="post">
                      <?php echo csrf_field(); ?>
                    <div class="float-left">
                        <select id="status" name="status" class="form-control selectric">
                            <option value=""><?php echo e(__('Action For Selected')); ?></option>
                            <option value="1"><?php echo e(__('Move To Active')); ?></option>
                            <option value="0"><?php echo e(__('Move To Deactivate')); ?></option>
                            <?php if($string != 2): ?>
                            <option value="2"><?php echo e(__('Move To Trash')); ?></option>
                            <?php endif; ?>
                            <?php if($string == 2): ?>
                            <option value="3"><?php echo e(__('Delete Permanently')); ?></option>
                            <?php endif; ?>      
                        </select>
                    </div>
                    <div class="clearfix mb-3"></div>
                    <div class="row">
                        <div class="col-md-12">
                         <?php if(Session::has('alert')): ?>
                         <div class="alert alert-danger">
                             <?php echo e(Session::get('alert')); ?>

                         </div>
                         <?php endif; ?>
                        </div>
                     </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="custom-checkbox custom-control">
                                            <input type="checkbox" 
                                                class="custom-control-input checkAll" id="checkbox-all">
                                            <label for="checkbox-all" class="custom-control-label">&nbsp;</label>
                                        </div>
                                    </th>
                                    <th><?php echo e(__('Avatar')); ?></th>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                 <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="custom-checkbox custom-control">
                                                <input name="ids[]" value="<?php echo e($row->id); ?>" type="checkbox" data-checkboxes="mygroup"
                                                    class="custom-control-input" id="checkbox-<?php echo e($row->id); ?>">
                                                <label for="checkbox-<?php echo e($row->id); ?>" class="custom-control-label">&nbsp;</label>
                                            </div>
                                        </td>
                                        <td>
                                            <img class="rounded-circle w-25" src="<?php echo e($row->avatar == '' ? 'https://ui-avatars.com/api/?name=' . $row->name : asset($row->avatar)); ?>" alt="">
                                        </td>
                                        <td><?php echo e($row->name); ?></td>
                                        <td>
                                            <?php echo e($row->email); ?>

                                        </td>
                                        <?php if($row->status == 1): ?>
                                            <td><div class="badge badge-success"><?php echo e(__('Active')); ?></div></td>
                                        <?php elseif($row->status == 0): ?>
                                            <td><div class="badge badge-danger"><?php echo e(__('Disabled')); ?></div></td>
                                        <?php else: ?>
                                            <td><div class="badge badge-danger"><?php echo e(__('Trash')); ?></div></td>
                                        <?php endif; ?>
                                        <td>
                                            <div class="dropdown d-inline">
                                                <button class="btn btn-primary dropdown-toggle" type="button"
                                                    id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    <?php echo e(__('Action')); ?>

                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.user.show', $row->id)); ?>"><i
                                                            class="fa fa-eye"></i><?php echo e(__('View')); ?></a>
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.user.edit', $row->id)); ?>"><i
                                                            class="fa fa-edit"></i><?php echo e(__('edit')); ?></a>
                                                    <a class="dropdown-item has-icon"
                                                        href="<?php echo e(route('admin.user.editplan', $row->id)); ?>"><i
                                                            class="fa fa-edit"></i><?php echo e(__('Edit Plan')); ?></a>
                                                    <a class="dropdown-item has-icon" href="<?php echo e(route('admin.user.login', $row->id)); ?>"><i class="fa fa-user"></i><?php echo e(__('Login')); ?></a>
                                                    <a class="dropdown-item has-icon delete-confirm"
                                                        href="javascript:void(0)" data-id=<?php echo e($row->id); ?>><i class="fa fa-trash"></i><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($users->appends($request->all())->links('vendor.pagination.bootstrap-4')); ?>

                    </div>
                </form>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <form class="d-none" id="delete_form_<?php echo e($row->id); ?>"
                    action="<?php echo e(route('admin.user.destroy', $row->id)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                </form>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="type" value="<?php echo e($request->filter ?? ''); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    "use strict";
    var type=$('#type').val();
    if(type != ''){
        $('#filter').val(type)
    }
    $('#status').on('change',()=>{
        $('#status_form').submit();  
    })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/admin/user/index.blade.php ENDPATH**/ ?>