<?php $__env->startSection('title','Create Order'); ?>

<?php $__env->startSection('head'); ?>
    <?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Create Order','prev'=> route('admin.order.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><?php echo e(__('Make Order')); ?></h4>
                <?php if(Session::has('message')): ?>
                    <p class="alert alert-danger">
                        <?php echo e(Session::get('message')); ?>

                    </p>
                <?php endif; ?>
            </div>
            <form method="POST" action="<?php echo e(route('admin.order.store')); ?>" class="basicform_with_reset">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="form-group row mb-4">
                        <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Email')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" class="form-control" placeholder="User Email" required name="email">
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Select Plan')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <select name="plan_id" class="form-control selectric">
                                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Select Plan')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <select name="getway_id" class="form-control selectric">
                                <?php $__currentLoopData = $getways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($getway->id); ?>"><?php echo e($getway->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Payment ID')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" class="form-control" placeholder="Payment ID" required name="payment_id">
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label text-md-right col-12 col-md-3 col-lg-3"><?php echo e(__('Status')); ?></label>
                        <div class="col-sm-12 col-md-7">
                            <select name="status" class="form-control">
                                <option value="1"><?php echo e(__('Active')); ?></option>
                                <option value="0"><?php echo e(__('Inactive')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                        <div class="col-sm-12 col-md-7">
                            <button type="submit"
                                class="btn btn-primary btn-lg  basicbtn"><?php echo e(__('Submit')); ?></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/my-works/laravel/timelock/script/resources/views/admin/order/create.blade.php ENDPATH**/ ?>