<?php $__env->startSection('title',config('app.name')); ?>

<?php $__env->startSection('content'); ?>
 <!-- slider area start -->
<section>
    <div class="slider-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="slider-content">
                        <h2><?php echo e($header->title ?? ''); ?></h2>
                        <p><?php echo e($header->short_title ?? ''); ?></p>
                        <?php if(isset($header->get_start_form)): ?>
                        <?php if($header->get_start_form == 'show'): ?>
                        <div class="slider-form">
                            <form action="<?php echo e(route('user.register')); ?>">
                                <div class="form-group">
                                    <input type="text" name="email" placeholder="Enter Your Email Address" class="form-control">
                                </div>
                                <div class="button-btn">
                                <button type="submit"><span class="iconify" data-icon="akar-icons:circle-plus" data-inline="false"></span> <?php echo e(__('Get Started')); ?></button>
                                </div>
                            </form>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="slider-right-area" style="background-image: url('<?php echo e(asset('uploads/header.png')); ?>');">
                        <?php if(isset($header->youtube_link)): ?>
                        <?php if(!empty($header->youtube_link)): ?>
                        <div class="slider-main-content">
                            <div class="slider-play-btn">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal">
                                    <span class="iconify" data-icon="clarity:play-solid" data-inline="false"></span>
                                </a>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(isset($header->youtube_link)): ?>
    <?php if(!empty($header->youtube_link)): ?>
    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <iframe width="auto" height="482" src="https://www.youtube.com/embed/<?php echo e(parse_yotube_url($header->youtube_link ?? '')); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>
</section>
<!-- slider area end -->

<!-- service area start -->
<div class="service-area pt-100 pb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="service-header-area text-center">
                    <div class="service-short-title">
                        <h5><?php echo e(__('features_short_title')); ?></h5>
                    </div>
                    <div class="service-title">
                        <h2><?php echo e(__('features_long_title')); ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-5">
            <?php $__currentLoopData = $features ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $info = json_decode($feature->featuremeta->value) ?>
            <div class="col-lg-3">
                <div class="single-service text-center">
                    <div class="service-icon icon-thumnail">
                    <?php if(!empty($info->icon)): ?>
                        <img style="background:<?php echo e($info->color); ?>" src="<?php echo e(asset($info->icon)); ?>" alt="">
                    <?php else: ?>
                        <span class="iconify" data-icon="carbon:manage-protection" data-inline="false"></span>
                    <?php endif; ?>
                    </div>
                    <div class="service-name">
                        <h4><?php echo e($feature->title); ?></h4>
                    </div>
                    <div class="service-des">
                        <p><?php echo e(Str::limit($info->short_description?? '',75)); ?></p>
                    </div>
                    <div class="service-action">
                        <a href="<?php echo e(route('feature.show',$feature->slug )); ?>"><span class="iconify" data-icon="bytesize:arrow-right" data-inline="false"></span></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<!-- service area end -->

<!-- feature area start -->
<div class="feature-area pb-100">
    <?php $about_info = json_decode($about->aboutmeta->value) ?>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="feature-img">
                    <img class="img-fluid" src="<?php echo e(asset($about_info->image)); ?>" alt="">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="feature-right-content-area">
                    <div class="feature-shot-title">
                        <h5><?php echo e($about_info->short_title); ?></h5>
                    </div>
                    <div class="feature-title">
                        <h2><?php echo e($about->title); ?></h2>
                    </div>
                    <div class="feature-des">
                        <p><?php echo e(Str::limit($about_info->short_description?? '',250)); ?></p>
                    </div>
                    <?php if($about_info->button_status == 1): ?>
                    <div class="feature-btn">
                        <a href="<?php echo e(route('about.index')); ?>"><?php echo e($about_info->button_text); ?><span class="iconify" data-icon="dashicons:arrow-right-alt2" data-inline="false"></span></a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- feature area end -->

<!-- about area start -->
<div class="about-area pb-100">
    <?php $analytic_info = json_decode($analytic->analyticmeta->value) ?>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-content-area">
                    <h2><?php echo e($analytic->title); ?></h2>
                    <p><?php echo e(Str::limit($analytic_info->short_description ?? '',250)); ?></p>
                    <?php if($analytic_info->button_status == 1): ?>
                    <div class="feature-btn">
                        <a href="<?php echo e(route('analytic.index')); ?>"><?php echo e($analytic_info->button_text); ?><span class="iconify" data-icon="dashicons:arrow-right-alt2" data-inline="false"></span></a>
                    </div>
                    <?php endif; ?>
                    
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about-are-img">
                    <?php if(!empty($analytic_info->image)): ?>
                        <img class="img-fluid" src="<?php echo e($analytic_info->image); ?>" alt="">
                    <?php else: ?>
                    <img class="img-fluid" src="<?php echo e(asset('uploads/about.svg')); ?>" alt="">
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- about area start -->
<?php if(count($plans) > 0): ?>
<!-- pricing area start -->
<div class="pricing-area mb-100 pt-150 pb-150">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="pricing-header-area text-center">
                    <div class="pricing-header">
                        <h2><?php echo e(__('pricing_title')); ?></h2>
                        <p><?php echo e(__('pricing_description')); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-5">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            if ($plan->duration == 30) {
                $duration='Monthly';
            }
            elseif($plan->duration == 365){
                    $duration='Yearly';
            }
            else{
                $duration=$plan->duration.' Days';
            }
            ?>
            <div class="col-lg-3">
                <div class="single-pricing <?php echo e($plan->is_featured == 1 ? 'active' : ''); ?>">
                    <div class="pricing-type">
                        <h6><?php echo e($plan->name); ?></h6>
                    </div>
                    <div class="pricing-price">
                        <sub><?php echo e(option('currency_icon')); ?></sub> <?php echo e(number_format($plan->price,2)); ?> <sub>/ <?php echo e($duration); ?></sub>
                    </div>
                    <div class="pricing-list">
                        <ul>
                            <li><span class="iconify" data-icon="akar-icons:check" data-inline="false"></span> <?php echo e($plan->project_limit); ?> <?php echo e(__('Project')); ?></li>
                            <li><span class="iconify" data-icon="akar-icons:check" data-inline="false"></span> <?php echo e(number_format($plan->storage_size,2)); ?> <?php echo e(__('MB')); ?></li>
                            <li><span class="iconify" data-icon="akar-icons:check" data-inline="false"></span> <?php echo e($plan->user_limit); ?> <?php echo e(__('Members')); ?></li>
                            <li><span class="iconify" data-icon="akar-icons:check" data-inline="false"></span> <?php echo e($plan->group_limit); ?> <?php echo e(__('Groups')); ?></li>

                            <li><span class="iconify <?php echo e($plan->screenshot == 1 ? '' : 'text-danger'); ?>" data-icon="akar-icons:<?php echo e($plan->screenshot == 1 ? 'check' : 'cross'); ?>" data-inline="false"></span><?php echo e(__('Screenshot Capture')); ?></li>

                            <li><span class="iconify <?php echo e($plan->gps == 1 ? '' : 'text-danger'); ?>" data-icon="akar-icons:<?php echo e($plan->gps == 1 ? 'check' : 'cross'); ?>" data-inline="false"></span> <?php echo e(__('Gps Tracking')); ?></li>

                                <li><span class="iconify <?php echo e($plan->adminable_project == 1 ? '' : 'text-danger'); ?>" data-icon="akar-icons:<?php echo e($plan->adminable_project == 1 ? 'check' : 'cross'); ?>" data-inline="false"></span> <?php echo e(__('Multi Admin Accessible Project')); ?></li>
                            
                            <li><span class="iconify <?php echo e($plan->mail_activity == 1 ? '' : 'text-danger'); ?>" data-icon="akar-icons:<?php echo e($plan->mail_activity == 1 ? 'check' : 'cross'); ?>" data-inline="false"></span> <?php echo e(__('Mail Activity')); ?></li>
                        </ul>
                    </div>
                    <div class="pricing-btn">
                        <a href="<?php echo e(route('plan.check', $plan->id)); ?>"><?php echo e(__('Get Started')); ?></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<!-- pricing area end -->
<?php endif; ?>
<!-- blog area start -->
<?php if(count($blogs) > 0): ?>
<section>
    <div class="blog-area mb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3">
                    <div class="blog-header-area text-center">
                        <h4><?php echo e(__('news_title')); ?></h4>
                        <p><?php echo e(__('news_description')); ?></p>
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4">
                    <div class="single-blog">
                        <div class="blog-img">
                            <img class="img-fluid" src="<?php echo e(asset($row->thum_image->value ?? '')); ?>" alt="">
                        </div>
                        <div class="blog-content">
                            <div class="blog-title">
                                <h3><?php echo e(Str::limit($row->title,55)); ?></h3>
                            </div>
                            <div class="blog-date">
                                <span><?php echo e($row->updated_at->format('F d, Y')); ?></span>
                            </div>
                            <div class="blog-des">
                                <p><?php echo e(Str::limit($row->excerpt->value ?? '',200)); ?></p>
                            </div>
                            <div class="blog-action">
                                <a href="<?php echo e(url('/blog',$row->slug)); ?>"><?php echo e(__('Read More')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<!-- blog area end -->
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<script src="<?php echo e(asset('frontend/assets/js/home.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/arafathossain/Downloads/codecanyon-Bt6blfNn-timelock-project-management-system-with-screenshot-capture/files/script/resources/views/index.blade.php ENDPATH**/ ?>