<?php $__env->startSection('title','Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-4 col-md-4 col-sm-12">
      <div class="card card-statistic-2">
        <div class="card-stats">
          <div class="card-stats-title"><?php echo e(__('Order Statistics')); ?> -
           <div class="dropdown d-inline">
            <a class="font-weight-600 dropdown-toggle" data-toggle="dropdown" href="#" id="orders-month" id="orders-month"><?php echo e(Date('F')); ?></a>
            <ul class="dropdown-menu dropdown-menu-sm">
              <li class="dropdown-title"><?php echo e(__('Select Month')); ?></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='January'): ?> active <?php endif; ?>" data-month="January" ><?php echo e(__('January')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='February'): ?> active <?php endif; ?>" data-month="February" ><?php echo e(__('February')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='March'): ?> active <?php endif; ?>" data-month="March" ><?php echo e(__('March')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='April'): ?> active <?php endif; ?>" data-month="April" ><?php echo e(__('April')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='May'): ?> active <?php endif; ?>" data-month="May" ><?php echo e(__('May')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='June'): ?> active <?php endif; ?>" data-month="June" ><?php echo e(__('June')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='July'): ?> active <?php endif; ?>" data-month="July" ><?php echo e(__('July')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='August'): ?> active <?php endif; ?>" data-month="August" ><?php echo e(__('August')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='September'): ?> active <?php endif; ?>" data-month="September" ><?php echo e(__('September')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='October'): ?> active <?php endif; ?>" data-month="October" ><?php echo e(__('October')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='November'): ?> active <?php endif; ?>" data-month="November" ><?php echo e(__('November')); ?></a></li>
              <li><a href="#" class="dropdown-item month <?php if(Date('F')=='December'): ?> active <?php endif; ?>" data-month="December" ><?php echo e(__('December')); ?></a></li>
            </ul>
          </div>
          </div>
          <div class="card-stats-items">
            <div class="card-stats-item">
              <div class="card-stats-item-count" id="pending_order"><img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" alt=""></div>
              <div class="card-stats-item-label"><?php echo e(__('Pending')); ?></div>
            </div>
            <div class="card-stats-item">
              <div class="card-stats-item-count" id="cancelled"><img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" alt=""></div>
              <div class="card-stats-item-label"><?php echo e(__('Cancelled')); ?></div>
            </div>
            <div class="card-stats-item">
              <div class="card-stats-item-count" id="completed_order"><img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" alt=""></div>
              <div class="card-stats-item-label"><?php echo e(__('Completed')); ?></div>
            </div>
          </div>
        </div>
        <div class="card-icon shadow-primary bg-primary">
          <i class="fas fa-archive"></i>
        </div>
        <div class="card-wrap">
          <div class="card-header">
            <h4><?php echo e(__('Total Orders')); ?></h4>
          </div>
          <div class="card-body" id="total_order">
            <img height="40" src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" alt="">
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-4 col-md-4 col-sm-12">
      <div class="card card-statistic-2">
        <div class="card-chart">
          <canvas id="sales_of_earnings_chart" height="80"></canvas>
        </div>
        <div class="card-icon shadow-primary bg-primary">
          <i class="fas fa-dollar-sign"></i>
        </div>
        <div class="card-wrap">
          <div class="card-header">
            <h4><?php echo e(__('Balance')); ?> - <?php echo e(date('Y')); ?></h4>
          </div>
          <div class="card-body" id="balance">
            <img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" alt="">
          </div>
        </div>
      </div>
    </div>
    <div class="col-lg-4 col-md-4 col-sm-12">
      <div class="card card-statistic-2">
        <div class="card-chart">
          <canvas id="total-sales-chart" height="80"></canvas>
        </div>
        <div class="card-icon shadow-primary bg-primary">
          <i class="fas fa-shopping-bag"></i>
        </div>
        <div class="card-wrap">
          <div class="card-header">
            <h4><?php echo e(__('Sales')); ?> - <?php echo e(date('Y')); ?></h4>
          </div>
          <div class="card-body" id="sales">
            <img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" alt="">
          </div>
        </div>
      </div>
    </div> 
</div>   
<div class="row">
    <div class="col-12 col-xl-8">
        <div class="row">
            <div class="col-12">
                <div class="card mt-4">
                    <div class="card-header">
                        <h4 class="card-header-title"><?php echo e(__('Earnings performance')); ?> <img src="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>" height="40" id="earning_performance"></h4>
                        <div class="card-header-action">                            
                        <select class="form-control" id="perfomace">
                            <option value="7"><?php echo e(__('Last 7 Days')); ?></option>
                            <option value="15"><?php echo e(__('Last 15 Days')); ?></option>
                            <option value="30" selected><?php echo e(__('Last 30 Da')); ?>ys</option>
                            <option value="365"><?php echo e(__('Last 365 Days')); ?></option>
                        </select>
                        </div>
                    </div>
                    <div class="card-body">
                      <canvas id="earning_performance_chart" height="158"></canvas> 
                </div>
            </div>
        </div>
    </div>
  </div>

  <div class="col-lg-4 col-md-12 col-12 col-sm-12">
    <div class="card mt-4">
      <div class="card-header">
        <h4><?php echo e(__('Recent Orders')); ?></h4>
      </div>
      <div class="card-body">
        <ul class="list-unstyled list-unstyled-border">
          <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="media">
            <a href="<?php echo e(route('admin.user.show',$order->user_id)); ?>"><img class="mr-3 rounded-circle" width="50" src="<?php echo e(asset(!empty($order->user->avatar) ? $order->user->avatar : 'https://ui-avatars.com/api/?name='.$order->user->name.'&background=random')); ?>" alt="avatar"></a>
            <div class="media-body">
              <div class="float-right text-primary mt-3"><a href="<?php echo e(url('/admin/order',$order->id)); ?>"><?php echo e($order->created_at->diffForHumans()); ?></a></div>
              <div class="media-title  mt-3"><a href="<?php echo e(route('admin.order.edit',$order->id)); ?>"><?php echo e($order->invoice_id); ?></a></div>
            </div>
          </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <?php if(count($orders) > 0): ?>
        <div class="text-center pt-1 pb-1">
          <a href="<?php echo e(route('admin.order.index')); ?>" class="btn btn-primary btn-lg btn-round">
            <?php echo e(__('View All')); ?>

          </a>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-lg-12">
    <div class="card">
      <div class="card-header">
        <h4><?php echo e(__('Expired Orders')); ?></h4>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-striped">
              <thead>
                  <tr>
                     
                      <th><?php echo e(__('Id')); ?></th>
                      <th><?php echo e(__('Payment Id')); ?></th>
                      <th><?php echo e(__('Plan Name')); ?></th>
                      <th><?php echo e(__('Amount')); ?></th>
                      <th><?php echo e(__('User')); ?></th>
                      <th><?php echo e(__('Status')); ?></th>
                      <th><?php echo e(__('Order At')); ?></th>
                      <th><?php echo e(__('Will Expire')); ?></th>
                  </tr>
              </thead>
              <tbody>
                  <?php $__currentLoopData = $expired_orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                         
                          <td><a href="<?php echo e(route('admin.user.invoice', $order->id)); ?>"><?php echo e($order->invoice_id); ?></a>
                          </td>
                          <td><?php echo e($order->payment_id); ?></td>
                          <td><?php echo e($order->plan->name); ?></td>
                          <td><?php echo e($order->amount); ?></td>
                          <td><a href="<?php echo e(route('admin.user.show', $order->user->id)); ?>"><?php echo e($order->user->name); ?></a>
                          </td>
                          <?php
                              $status = [
                                  0 => ['class' => 'badge-danger', 'text' => 'Rejected'],
                                  1 => ['class' => 'badge-primary', 'text' => 'Accepted'],
                                  2 => ['class' => 'badge-danger', 'text' => 'Expired'],
                                  3 => ['class' => 'badge-warning', 'text' => 'Pending'],
                                  4 => ['class' => 'badge-danger', 'text' => 'Trash'],
                              ][$order->status];
                          ?>
                          <td>
                              <span class="badge <?php echo e($status['class']); ?>"><?php echo e($status['text']); ?></span>
                          </td>
                          <td><?php echo e(date('Y-m-d', strtotime($order->created_at))); ?></td>
                          <td><?php echo e($order->will_expire); ?></td>
                      </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
          </table>
      </div>
      </div>
    </div>
</div>
</div>
<input type="hidden" id="base_url" value="<?php echo e(url('/')); ?>">
<input type="hidden" id="month" value="<?php echo e(date('F')); ?>">
<input type="hidden" id="gif_url" value="<?php echo e(asset('frontend/assets/img/loader.gif')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/chart.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/admin/assets/js/jquery.sparkline.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/admin/assets/js/admin_dashboard.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/arafathossain/Desktop/laravel/timelock-final/script/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>