<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php echo SEOMeta::generate(); ?>

    <?php echo OpenGraph::generate(); ?>

    <?php echo Twitter::generate(); ?>

    <?php echo JsonLd::generate(); ?>

    <?php echo JsonLdMulti::generate(); ?>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <link rel="icon" href="<?php echo e(asset('uploads/favicon.ico')); ?>">
    <!-- css here -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/hc-offcanvas-nav.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/font.css')); ?>">
    <?php echo $__env->yieldPushContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/responsive.css')); ?>">
</head>
<body>
    <?php
    $theme_settings = App\Models\Option::where('key','theme_settings')->first();
    $theme_info = json_decode($theme_settings->value);
    ?>
    <!--- Header Section ---->
    <?php echo $__env->make('layouts.frontend.partials.header',['theme_info'=>$theme_info], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <!--- footer Section ---->
    <?php echo $__env->make('layouts.frontend.partials.footer',['theme_info'=>$theme_info], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- js here -->
    <script src="<?php echo e(asset('frontend/assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/iconify.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/hc-offcanvas-nav.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/script.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>
</html>
<?php /**PATH /Users/arafathossain/Desktop/laravel/timelock-final/script/resources/views/layouts/frontend/app.blade.php ENDPATH**/ ?>